//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ Functions
//:
//: Functions are grouped lines of code that can be executed together.
//:
//: They are closures with a name (named closures).
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// using a function
func greetFunction(person: String) -> String {
    return "Hello \(person),"
}

// using a closure (and storing it within a variable)
let greetClosure: (String) -> String = { person in
    return "Hello \(person),"
}


//:
//: -------------------
//:
//: ## Input Parameters
//:
//: We can name our input parameters with variable names.
//:
//: -------------------
//:


// declare a closure
let closure: ((String, String) -> String) = { variable1, variable2 in
    return variable1 + variable2
}
// execute
closure("Bob", "Tuesday")


// declare a named closure (a function)
func name(label1 variable1: String, label2 variable2: String) -> String {
    return variable1 + variable2
}
// Execute
name(label1: "argument 1", label2:  "argument 2")


//:
//: -------------------
//:
//: ## Parameter Labels & Variable Names
//:
//: We can give the parameter label and variable name the same value and only declare it once.
//:
//: -------------------
//:


// can merge labels and variable names together
func greet(person: String, day: String) -> String {
    return "Hello \(person), today is \(day)."
}
greet(person: "Bob", day: "Tuesday")


//:
//: -------------------
//:
//: ## Nested functions
//:
//: Functions can be nested.
//:
//: Nested functions have access to variables that were declared in the outer function.
//:
//: -------------------
//:


func returnFifteen() -> Int {
    var y = 10
    func add() {
        y += 5
    }
    add()
    return y
}
returnFifteen()


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
